unit Demodraw;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Toggler, StdCtrls, Custbtn, ExtCtrls, Balloon;

type
  TOwnerDrawControls = class(TForm)
    btnDraw: TODButton;
    GroupBox1: TGroupBox;
    rbRoundRect: TODRadioButton;
    rbRect: TODRadioButton;
    GroupBox2: TGroupBox;
    rbBalloon: TODRadioButton;
    rbCustom: TODRadioButton;
    rbDefault: TODRadioButton;
    GroupBox3: TGroupBox;
    cycHintColor: TODCycler;
    GroupBox4: TGroupBox;
    chkEnableHints: TODCheckBox;
    procedure rbShapeClick(Sender: TObject);
    procedure rbTypeClick(Sender: TObject);
    procedure chkEnableHintsClick(Sender: TObject);
    procedure cycHintColorClick(Sender: TObject);
    procedure rbShapePaint(Sender: TObject);
    procedure rbTypePaint(Sender: TObject);
    procedure chkEnableHintsPaint(Sender: TObject);
    procedure cycHintColorPaint(Sender: TObject);
    procedure btnDrawPaint(Sender: TObject);
  private
    procedure PaintBalloon(cvs: TCanvas; col: TColor;
      Shape: TBalloonShape);
    procedure InitBackground(cvs: TCanvas; r: TRect; foc: Boolean);
    procedure RefreshEm;
  public
    { Public declarations }
  end;

var
  OwnerDrawControls: TOwnerDrawControls;

implementation

uses Demomain;

{$R *.DFM}

procedure TOwnerDrawControls.RefreshEm;
begin
  rbRoundRect.Refresh;
  rbRect.Refresh;
  rbBalloon.Refresh;
  rbCustom.Refresh;
  rbDefault.Refresh;
  cycHintColor.Refresh;
  chkEnableHints.Refresh;
end;

procedure TOwnerDrawControls.InitBackground(cvs: TCanvas; r: TRect; foc: Boolean);
begin
  cvs.FillRect(r);
  if foc then begin
    InflateRect(r, -1, -1);
    cvs.DrawFocusRect(r);
  end;
end;

procedure TOwnerDrawControls.PaintBalloon(cvs: TCanvas; col: TColor;
  Shape: TBalloonShape);
var
  r: TRect;
  r1, r2, r3: HRgn;
  pts: array[0..2] of TPoint;
  balBottom: Integer;
begin
  r := Rect(4, 4, 48, 48);
  cvs.Brush.Color := col;
  balBottom := (r.bottom * 2) div 3;
  if Shape = bsRoundRect then
    r1 := CreateRoundRectRgn(r.left, r.top, r.right, balBottom + 1, 10, 10)
  else
    r1 := CreateRectRgn(r.left, r.top, r.right, balBottom + 1);
  pts[0] := Point(r.left, r.bottom);
  pts[1] := Point(r.left + 5, balBottom);
  pts[2] := Point(r.left + 10, balBottom);
  r2 := CreatePolygonRgn(pts, 3, ALTERNATE);
  r3 := CreateRectRgn(0, 0, 1, 1);
  CombineRgn(r3, r2, r1, RGN_OR);
  PaintRgn(cvs.Handle, r3);
  cvs.Brush.Color := clWindowFrame;
  FrameRgn(cvs.Handle, r3, cvs.Brush.Handle, 1, 1);
  DeleteObject(r1);
  DeleteObject(r2);
  DeleteObject(r3);
end;

procedure TOwnerDrawControls.rbShapeClick(Sender: TObject);
begin
  if rbRect.Checked then
    FrontPanel.BalloonHint.Shape := bsRectangle
  else
    FrontPanel.BalloonHint.Shape := bsRoundRect;
  RefreshEm;
end;

procedure TOwnerDrawControls.rbTypeClick(Sender: TObject);
begin
  if rbBalloon.Checked then
    FrontPanel.BalloonHint.Active := True
  else if rbCustom.Checked then
    FrontPanel.CustomHint.Active := True
  else begin
    FrontPanel.BalloonHint.Active := False;
    FrontPanel.CustomHint.Active := False;
  end;
end;

procedure TOwnerDrawControls.chkEnableHintsClick(Sender: TObject);
begin
  Application.ShowHint := chkEnableHints.Checked;
end;

procedure TOwnerDrawControls.cycHintColorClick(Sender: TObject);
var
  col: TColor;
begin
  case cycHintColor.Value of
    0:  col := clWhite;
    1:  col := $0080FFFF;
    2:  col := $00FFFF80;
  end;
  Application.HintColor := col;
  RefreshEm;
end;

procedure TOwnerDrawControls.rbShapePaint(Sender: TObject);
var
  rb: TODRadioButton;
  col: TColor;
begin
  rb := TODRadioButton(Sender);
  rb.Canvas.Brush.Style := bsSolid;
  InitBackground(rb.Canvas, rb.ClientRect, rb.Focused);
  if rb.Checked then
    col := Application.HintColor
  else
    col := clBtnFace;
  if Sender = rbRect then
    PaintBalloon(rb.Canvas, col, bsRectangle)
  else
    PaintBalloon(rb.Canvas, col, bsRoundRect);
end;

procedure TOwnerDrawControls.rbTypePaint(Sender: TObject);
var
  rb: TODRadioButton;
  col: TColor;
  r: TRect;
begin
  rb := TODRadioButton(Sender);
  rb.Canvas.Brush.Style := bsSolid;
  InitBackground(rb.Canvas, rb.ClientRect, rb.Focused);
  if rb.Checked then
    col := Application.HintColor
  else
    col := clBtnFace;
  if Sender = rbBalloon then begin
    PaintBalloon(rb.Canvas, col, FrontPanel.BalloonHint.Shape);
    r := Rect(52, 0, 124, 52);
    rb.Canvas.Brush.Style := bsClear;
    DrawText(rb.Canvas.Handle, 'Balloon', -1, r, DT_VCENTER or DT_SINGLELINE);
  end
  else if Sender = rbCustom then begin
    rb.Canvas.Brush.Color := col;
    rb.Canvas.Rectangle(4, 4, 48, 48);
    r := Rect(52, 0, 124, 52);
    rb.Canvas.Brush.Style := bsClear;
    DrawText(rb.Canvas.Handle, 'Custom', -1, r, DT_VCENTER or DT_SINGLELINE);
  end
  else begin {rbDefault}
    rb.Canvas.Brush.Color := col;
    rb.Canvas.Rectangle(6, 6, 110, 24);
    r := Rect(120, 0, 256, 30);
    rb.Canvas.Brush.Style := bsClear;
    DrawText(rb.Canvas.Handle, 'Default', -1, r, DT_VCENTER or DT_SINGLELINE);
  end;
end;

procedure TOwnerDrawControls.chkEnableHintsPaint(Sender: TObject);
var
  chk: TODCheckBox;
begin
  chk := TODCheckBox(Sender);
  InitBackground(chk.Canvas, chk.ClientRect, chk.Focused);
  chk.Canvas.Brush.Style := bsSolid;
  PaintBalloon(chk.Canvas, Application.HintColor, FrontPanel.BalloonHint.Shape);
  if not chk.Checked then begin
    chk.Canvas.Brush.Style := bsClear;
    chk.Canvas.Pen.Color := clRed;
    chk.Canvas.Pen.Width := 4;
    chk.Canvas.MoveTo(8, 8);
    chk.Canvas.LineTo(44, 44);
    chk.Canvas.MoveTo(8, 44);
    chk.Canvas.LineTo(44, 8);
  end;
end;
procedure TOwnerDrawControls.cycHintColorPaint(Sender: TObject);
var
  cyc: TODCycler;
  col: TColor;
begin
  cyc := TODCycler(Sender);
  InitBackground(cyc.Canvas, cyc.ClientRect, cyc.Focused);
  case cyc.Value of
    0:  col := clWhite;
    1:  col := $0080FFFF;
    2:  col := $00FFFF80;
  end;
  PaintBalloon(cyc.Canvas, col, FrontPanel.BalloonHint.Shape);
end;

procedure TOwnerDrawControls.btnDrawPaint(Sender: TObject);
var
  btn: TODButton;
  r: TRect;
  x, y: Integer;
begin
  btn := TODButton(Sender);
  btn.Canvas.Pen.Width := 1;
  btn.Canvas.Brush.Color := clBtnFace;
  btn.Canvas.Brush.Style := bsSolid;
  btn.Canvas.FillRect(btn.ClientRect);
  if btn.IsDown then begin
    btn.Canvas.Brush.Color := clBlack;
    btn.Canvas.Font.Color := clWhite;
  end
  else begin
    btn.Canvas.Brush.Color := clWhite;
    btn.Canvas.Font.Color := clBlack;
  end;
  r := btn.ClientRect;
  InflateRect(r, -2, -2);
  if btn.Default then
    btn.Canvas.Pen.Width := 3;
  btn.Canvas.RoundRect(r.left, r.top, r.right, r.bottom, 10, 10);

  x := (btn.Width div 2) - (btn.Canvas.TextWidth('OK') div 2);
  y := (btn.Height div 2) - (btn.Canvas.TextHeight('OK') div 2);
  btn.Canvas.TextOut(x, y, 'OK');
  if btn.Focused then begin
    r.left := x;
    r.top := y;
    r.right := x + btn.Canvas.TextWidth('OK');
    r.bottom := y + btn.Canvas.TextHeight('OK');
    btn.Canvas.DrawFocusRect(r);
  end;
end;

end.
